(function () {
    'use strict';

    const PLUGIN_ID = kintone.$PLUGIN_ID;
    const config = kintone.plugin.app.getConfig(PLUGIN_ID);


    /* ------------------------------------------------
         設定なしなら終了
    ------------------------------------------------ */
    if (!config.settings) return;

    const settings = JSON.parse(config.settings);

    const FIELD = settings.targetField;
    const TYPE = settings.fieldType;
    const MODE = settings.colorMode;
    const RULES = settings.rules;

    function normalize(s) {
        return String(s || '').trim().toLowerCase();
    }

    function findRule(value) {

        if (!value || (Array.isArray(value) && value.length === 0)) {
            return RULES.find(r => normalize(r.value) === '');
        }

        if (TYPE === 'CHECK_BOX') {
            if (!Array.isArray(value)) return null;
            return RULES.find(r => value.includes(r.value));
        }

        if (TYPE === 'DROP_DOWN' || TYPE === 'RADIO_BUTTON') {
            return RULES.find(r => normalize(value) === normalize(r.value));
        }

        if (TYPE === 'SINGLE_LINE_TEXT' || TYPE === 'MULTI_LINE_TEXT') {
            const val = normalize(value);
            return RULES.find(r => val.includes(normalize(r.value)));
        }

        return null;
    }

    kintone.events.on('app.record.index.show', event => {
        const records = event.records;
        const cells = kintone.app.getFieldElements(FIELD);
        if (!cells) return event;

        for (let i = 0; i < cells.length; i++) {
            const value = records[i][FIELD].value;
            const rule = findRule(value);
            if (!rule) continue;

            const color = rule.color;

            if (MODE === 'row') {
                const tr = cells[i].closest('tr');
                if (tr) tr.style.backgroundColor = color;
            } else {
                cells[i].style.backgroundColor = color;
            }
        }

        return event;
    });

})();
