(function () {
    "use strict";

    const PLUGIN_ID = kintone.$PLUGIN_ID;
    const config = kintone.plugin.app.getConfig(PLUGIN_ID);

    const pluginName = config.pluginName || "一覧検索プラグイン(試用版)";

    // ▼ 6時間（ミリ秒）
    const INTERVAL = 6 * 60 * 60 * 1000;

    // ▼ プラグインごとに独立したキーを作る
    const STORAGE_KEY = `susumu_trial_last_${PLUGIN_ID}`;

    kintone.events.on("app.record.index.show", () => {

        // ----- 直近の表示時間を確認 -----
        const lastShown = localStorage.getItem(STORAGE_KEY);
        const now = Date.now();

        if (lastShown && (now - Number(lastShown)) < INTERVAL) {
            // 6時間以内 → 出さない
            return;
        }

        // ----- モーダル生成 -----
        const overlay = document.createElement("div");
        overlay.className = "susumu-modal-overlay";

        const modal = document.createElement("div");
        modal.className = "susumu-modal";

        modal.innerHTML = `
            <div style="display:flex; align-items:center; gap:12px;">
                <h2 style="margin:0; font-size:20px; color:#333; font-weight:bold">
                    ${pluginName}
                </h2>
            </div>

            <p style="margin-top:18px;">
                ⚠ このプラグインは <strong>試用版</strong> です。
            </p>
            <p>正式版をご希望の場合は下記よりお問い合わせください。</p>

            <p style="margin-top:12px;">
                <strong>お問い合わせフォーム:</strong>
                <a href="https://susumu-inc.jp/contact/" target="_blank" rel="noopener noreferrer">
                    https://susumu-inc.jp/contact/
                </a><br>
                <strong>メール:</strong> shintaro.inoue@susumu-inc.jp<br>
                <strong>Tel :</strong> 075-585-3022
            </p>

            <button class="susumu-modal-close">閉じる</button>
        `;

        overlay.appendChild(modal);
        document.body.appendChild(overlay);

        modal.querySelector(".susumu-modal-close").onclick = () => {
            overlay.remove();
            // ▼ 今表示した時間を保存（次は6時間後）
            localStorage.setItem(STORAGE_KEY, now);
        };
    });

})();
